/*
 * Decompiled with CFR 0.152.
 */
package com.ageofelysian.ageofperformance.generator;

import com.ageofelysian.ageofperformance.SimpleSkullType;
import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2350;
import net.minecraft.class_2549;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public class SkullModelProvider
extends FabricModelProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final FabricDataOutput output;
    private static final Map<String, String> textureToHash = new ConcurrentHashMap<String, String>();

    public SkullModelProvider(FabricDataOutput output) {
        super(output);
        this.output = output;
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return CompletableFuture.runAsync(() -> {
            Path assets = this.output.method_45972(class_7784.class_7490.field_39368);
            this.addSimpleSkull(writer, assets);
            this.addSimpleWallSkull(writer, assets);
        });
    }

    private void addSimpleSkull(class_7403 writer, Path assets) {
        JsonObject blockState = new JsonObject();
        JsonObject variants = new JsonObject();
        for (SimpleSkullType type : SimpleSkullType.values()) {
            String name = type.getName();
            JsonObject variant = new JsonObject();
            variant.addProperty("model", "age_of_performance:block/" + name);
            variants.add("type=" + name, (JsonElement)variant);
            try {
                Path texturesPath = assets.resolve("age_of_performance/textures/block");
                this.saveTexture(texturesPath, type, writer);
                JsonObject root = this.generateModel(name, false);
                Path modelPath = assets.resolve("age_of_performance/models/block/" + name + ".json");
                byte[] json = GSON.toJson((JsonElement)root).getBytes(StandardCharsets.US_ASCII);
                writer.method_43346(modelPath, json, HashCode.fromBytes((byte[])json));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        blockState.add("variants", (JsonElement)variants);
        try {
            Path simpleSkull = assets.resolve("age_of_performance/blockstates/simple_skull.json");
            byte[] json = GSON.toJson((JsonElement)blockState).getBytes(StandardCharsets.US_ASCII);
            writer.method_43346(simpleSkull, json, HashCode.fromBytes((byte[])json));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addSimpleWallSkull(class_7403 writer, Path assets) {
        JsonObject blockState = new JsonObject();
        JsonObject variants = new JsonObject();
        for (SimpleSkullType type : SimpleSkullType.values()) {
            String name = type.getName();
            for (class_2350 direction : class_2549.field_11724.method_11898()) {
                JsonObject variant = new JsonObject();
                variant.addProperty("model", "age_of_performance:block/" + name + "_wall");
                variant.addProperty("y", (Number)(direction.method_10161() * 90));
                variants.add("type=" + name + ",facing=" + direction.method_10151(), (JsonElement)variant);
            }
            try {
                Path texturesPath = assets.resolve("age_of_performance/textures/block");
                this.saveTexture(texturesPath, type, writer);
                JsonObject root = this.generateModel(name, true);
                Path modelPath = assets.resolve("age_of_performance/models/block/" + name + "_wall.json");
                byte[] json = GSON.toJson((JsonElement)root).getBytes(StandardCharsets.US_ASCII);
                writer.method_43346(modelPath, json, HashCode.fromBytes((byte[])json));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        blockState.add("variants", (JsonElement)variants);
        try {
            Path simpleSkull = assets.resolve("age_of_performance/blockstates/simple_wall_skull.json");
            byte[] json = GSON.toJson((JsonElement)blockState).getBytes(StandardCharsets.US_ASCII);
            writer.method_43346(simpleSkull, json, HashCode.fromBytes((byte[])json));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveTexture(Path texturesPath, SimpleSkullType type, class_7403 writer) throws IOException {
        BufferedImage image = ImageIO.read(URI.create(type.getTextureUrl()).toURL());
        byte[] top = SkullModelProvider.extractSkullFace(image, 8, 0);
        byte[] bottom = SkullModelProvider.extractSkullFace(image, 16, 0);
        byte[] right = SkullModelProvider.extractSkullFace(image, 0, 8);
        byte[] front = SkullModelProvider.extractSkullFace(image, 8, 8);
        byte[] left = SkullModelProvider.extractSkullFace(image, 16, 8);
        byte[] back = SkullModelProvider.extractSkullFace(image, 24, 8);
        textureToHash.put(type.getName() + "_top", UUID.nameUUIDFromBytes(top).toString());
        textureToHash.put(type.getName() + "_bottom", UUID.nameUUIDFromBytes(bottom).toString());
        textureToHash.put(type.getName() + "_front", UUID.nameUUIDFromBytes(front).toString());
        textureToHash.put(type.getName() + "_right", UUID.nameUUIDFromBytes(right).toString());
        textureToHash.put(type.getName() + "_back", UUID.nameUUIDFromBytes(back).toString());
        textureToHash.put(type.getName() + "_left", UUID.nameUUIDFromBytes(left).toString());
        writer.method_43346(texturesPath.resolve(String.valueOf(UUID.nameUUIDFromBytes(top)) + ".png"), top, HashCode.fromBytes((byte[])top));
        writer.method_43346(texturesPath.resolve(String.valueOf(UUID.nameUUIDFromBytes(bottom)) + ".png"), bottom, HashCode.fromBytes((byte[])bottom));
        writer.method_43346(texturesPath.resolve(String.valueOf(UUID.nameUUIDFromBytes(front)) + ".png"), front, HashCode.fromBytes((byte[])front));
        writer.method_43346(texturesPath.resolve(String.valueOf(UUID.nameUUIDFromBytes(right)) + ".png"), right, HashCode.fromBytes((byte[])right));
        writer.method_43346(texturesPath.resolve(String.valueOf(UUID.nameUUIDFromBytes(back)) + ".png"), back, HashCode.fromBytes((byte[])back));
        writer.method_43346(texturesPath.resolve(String.valueOf(UUID.nameUUIDFromBytes(left)) + ".png"), left, HashCode.fromBytes((byte[])left));
    }

    private JsonObject generateModel(String name, boolean wall) {
        JsonObject root = new JsonObject();
        JsonObject textures = SkullModelProvider.getModelTextures(name);
        root.add("textures", (JsonElement)textures);
        JsonArray elements = new JsonArray();
        JsonObject element = new JsonObject();
        JsonArray from = new JsonArray();
        JsonArray to = new JsonArray();
        if (!wall) {
            from.add((Number)4);
            from.add((Number)0);
            from.add((Number)4);
            to.add((Number)12);
            to.add((Number)8);
            to.add((Number)12);
        } else {
            from.add((Number)4);
            from.add((Number)4);
            from.add((Number)0);
            to.add((Number)12);
            to.add((Number)12);
            to.add((Number)8);
        }
        element.add("from", (JsonElement)from);
        element.add("to", (JsonElement)to);
        JsonObject faces = new JsonObject();
        faces.add("up", (JsonElement)this.generateFace("up", wall));
        faces.add("down", (JsonElement)this.generateFace("down", wall));
        faces.add("north", (JsonElement)this.generateFace("north", wall));
        faces.add("east", (JsonElement)this.generateFace("east", wall));
        faces.add("south", (JsonElement)this.generateFace("south", wall));
        faces.add("west", (JsonElement)this.generateFace("west", wall));
        element.add("faces", (JsonElement)faces);
        elements.add((JsonElement)element);
        root.add("elements", (JsonElement)elements);
        return root;
    }

    @NotNull
    private static JsonObject getModelTextures(String name) {
        JsonObject textures = new JsonObject();
        textures.addProperty("particle", "minecraft:block/soul_sand");
        textures.addProperty("up", "age_of_performance:block/" + textureToHash.get(name + "_top"));
        textures.addProperty("down", "age_of_performance:block/" + textureToHash.get(name + "_bottom"));
        textures.addProperty("north", "age_of_performance:block/" + textureToHash.get(name + "_back"));
        textures.addProperty("east", "age_of_performance:block/" + textureToHash.get(name + "_left"));
        textures.addProperty("south", "age_of_performance:block/" + textureToHash.get(name + "_front"));
        textures.addProperty("west", "age_of_performance:block/" + textureToHash.get(name + "_right"));
        return textures;
    }

    private JsonObject generateFace(String direction, boolean wall) {
        JsonObject face = new JsonObject();
        face.addProperty("texture", "#" + direction);
        JsonArray uv = new JsonArray();
        uv.add((Number)0);
        uv.add((Number)0);
        uv.add((Number)16);
        uv.add((Number)16);
        face.add("uv", (JsonElement)uv);
        if (!wall) {
            if (direction.equals("down")) {
                face.addProperty("cullface", "down");
            }
        } else if (direction.equals("north")) {
            face.addProperty("cullface", "north");
        }
        return face;
    }

    public String method_10321() {
        return "age-of-performance model provider";
    }

    public static byte[] extractSkullFace(BufferedImage image, int x, int y) throws IOException {
        BufferedImage cropped = image.getSubimage(x, y, 8, 8);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)cropped, "png", out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

